clear all
set more off

global projectpath "C:/Users/Public/Documents/ProjetMESRI/ReplicationQJE"
cd "${projectpath}"

// Create virtual environment
	cap shell rmdir /s /q "./ado"
	mkdir "./ado"
	sysdir set PLUS "./ado"
	// install requirements
	ssc install gtools
	ssc install ftools
	ssc install reghdfe
	ssc install astile
	ssc install renvarlab
	ssc install jarowinkler 
	ssc install ppmlhdfe
	ssc install estout 
	ssc install listtex
	
// Set paths	
global outpath 		"${projectpath}/OUT"
global data 		"${projectpath}/DATA"
global tmp 			"${projectpath}/TMP"
global utils 		"${projectpath}/Code/Utils"
global code 		"${projectpath}/Code"

global RPath 		"C:/Program Files/R/R-4.3.1/bin/Rscript.exe" // Path to R
global SASPath 		"C:\Program Files\SASHome\SASFoundation\9.4\sas.exe" // Path to sas (for extraction of raw admin data)
global rawsource	"\\casd.fr\casdfs\Projets\IMPCRED\Data\" // Where raw administrative data are stored
global pathgeo "\\casd\casdfs\LibreAcces\Nomenclatures géographiques" // Administrative built-in geographical data

cap shell rmdir /s /q "./TMP"
cap shell rmdir /s /q "./OUT"

mkdir "./TMP"
mkdir "./OUT"


	
// install rpackages

local file = "${utils}/installpackages.R"
shell "${RPath}" "`file'" 

// Set constants

global MIN_DOI 5
global NORMYEAR 2010
global cond_accept = "NAF_labex_accept == 1 & ZE_labex_accept == 1" 
global condDADS "if (s_brut>0 & !mi(s_brut)) & inlist(filt,1,2)"


// Programs to generate output
run "${utils}/prog_gentable.do"
run "${utils}/prog_addstar.do"

// Extraction of raw data
run "${code}/_0a_extrdads.do"
run "${code}/_0b_extrbrn.do"
run "${code}/_0c_extrgecir.do"
run "${code}/_0d_extrREE.do"

// Programs to build utils files (crosswalk etc...)
run "${code}/_0e_setuputile.do"

// Data construction
run "${code}/_1a_loaddads.do"
run "${code}/_1b_loadpatents.do"
run "${code}/_1c_loadCIR.do"
run "${code}/_1d_loadCIFRE.do"
run "${code}/_1e_REE.do"
run "${code}/_1f_JEU.do"
run "${code}/_1g_jobflow.do"


// Data analysis

run "${code}/_2a_buildshares.do"
run "${code}/_2b_exposure.do"
run "${code}/_2c_regressor.do"
run "${code}/_2d_merging.do"
run "${code}/_2e_cleaning.do"

// Generate main tables and figures

run "${code}/_3_Figure1.do"
run "${code}/_3_Figure2.do"
run "${code}/_3_Figure3.do"
run "${code}/_3_Figure4.do"
run "${code}/_3_Table2.do"
run "${code}/_3_Table3.do"
run "${code}/_3_Table4.do"
run "${code}/_3_Table6.do"

// appendix

run "${code}/_4_TableA1.do"
run "${code}/_4_TableA2.do"
run "${code}/_4_TableA3-A4.do"
run "${code}/_4_TableA5.do"
run "${code}/_4_TableA6.do"
run "${code}/_4_TableA7.do"
run "${code}/_4_TableA8.do"
run "${code}/_5_FigureB1.do"
run "${code}/_5_FigureB2.do"
run "${code}/_5_FigureB3.do"
run "${code}/_5_FigureB4.do"
run "${code}/_5_FigureB5.do"
run "${code}/_5_FigureB6-B8.do"




